#declare tower = true;  // Alatiedostot kyttvt tt, jos tm on mritelty, ne eivt mrittele omia kameroitaan ja valojaan.

/*
  tower.pov
  Tss tiedostossa mritelln tornin kiviosat. Ne voivat olla ehjt tai hajonneet.
  Jos torni on hajonnut, siit puuttuu 252 tiilt, jotka joku perfektionisti varmaan 
  sijoittelisi ksi (siksi tiili on public).

  public
    tiili       - Suuri kivilohkare (kappale), joista torni on rakennettu.
    kerros      - Tornin yhden kerroksen korkeus, kerroksia on yhteens nelj.
    sisa        - Tornin sisnurkkien koordinaatit ovat (+/-sisa.u,+/-sisa.v).
    ulko        - Tornin ulkonurkkien koordinaatit ovat (+/-ulko.u,+/-ulko.v).
    kunto       - Tornin kunto boolean-arvolla. Jos torni on ehj, niin arvona true.
    detail      - Tornin yksityiskohtien laatu. True-arvo nytt kaikki yksityiskohdat.

  Erikoiset
    no_tower    - Muuttujan mrittely jossain tiedostossa est tornin piirtmisen.
*/


// Paikalliset kamera ja valaistus (jos main_file mritelty, niin unohda koko juttu)
#ifndef (RuinedTower)
  light_source { <10,20,-20> color rgb 1 }
  camera { location <8,4,-8> look_at <0,4,0> }
#end

// Vakiot (ei kannata muuttaa, seiniss olevat reijt saattaisivat muodostua liian mielenkiintoisiksi)
#local tile_x = 8;          // Monta tiilt leve yksi sein on?
#local tile_y = 8;          // Montako tiilt korkea peruskerros on?

#local korkeus = .25;       // Tiilen korkeus
#local pituus = .5;         // Tiilen pitkn sivun pituus
#local leveys = .5*pituus;  // Tiilen leveys (puoles pituudesta)
#local reunus = .035;        // Reunan osuus mitoista


// Niden pit nky ulkopuolelle, nist olisi ollut hyty tuolla alempanakin...
#declare kerros = tile_y * korkeus;
#declare sisa = pituus*(tile_x*0.5-0.25);
#declare ulko = pituus*(tile_x*0.5+0.25);
#ifndef (kunto) #declare kunto = false; #end
#ifndef (detail) #declare detail = true; #end

// Mrittele tiili (kytten edellisi vakioita) niin ett se nkyy mys ulospin.
#declare wall_colour = texture { 
  pigment { 
    granite       
    color_map {
        [0 color rgb <.5,.5,.5>]
        [0.4 color rgb <.8,.7,.7>]
        [1 color rgb <.5,.5,.5>]
    }
    scale .5
  } 
  #if (detail) normal { crackle scale .25 } #end
}

#declare tiili = difference {
  box {<0*pituus,0*korkeus,0*leveys> <pituus,korkeus,leveys> translate <-pituus/2,-korkeus/2,-leveys/2>}
  #if (detail)
  plane { y 0 rotate 45*x translate <-pituus/2,-korkeus/2,-leveys/2+reunus>}
  plane { y 0 rotate 45*x translate <-pituus/2,-korkeus/2,-leveys/2+reunus> rotate x*90 }
  plane { y 0 rotate 45*x translate <-pituus/2,-korkeus/2,-leveys/2+reunus> rotate x*180}
  plane { y 0 rotate 45*x translate <-pituus/2,-korkeus/2,-leveys/2+reunus> rotate x*270}
  plane { x 0 rotate 45*y translate <-pituus/2-.1,0,0> }
  plane { x 0 rotate 45*y translate <-pituus/2-.1,0,0> rotate y*180 }
  plane { x 0 rotate -45*y translate <-pituus/2-.1,0,0> }
  plane { x 0 rotate -45*y translate <-pituus/2-.1,0,0> rotate y*180 }
  plane { x 0 rotate -45*z translate <-korkeus-.1,0,0> }
  plane { x 0 rotate -45*z translate <-korkeus-.1,0,0> rotate y*180 }
  plane { x 0 rotate 45*z translate <-korkeus-.1,0,0> }
  plane { x 0 rotate 45*z translate <-korkeus-.1,0,0> rotate y*180 }
  #end
  translate -<-pituus/2,-korkeus/2,-leveys/2> 
}
object {tiili}


/*
  tower_details.pov - listn tiedostoon vasta loppuvaiheessa, kaikkien mrittelyjen jlkeen
    palkki      - Osittain seinn lpi tuleva vaakasuora kannatinpalkki

*/
#include "tower_details.pov"


// Tehdn seinelementit tornia varten.

// Sisnurkkien koordinaatit (x,z) ovat (+/-pituus*(tile_x*.5+0.25), +/-pituus*(tile_x*.5+0.25) )
// Ulkonurkkien koordinaatit saa tst muuttamalla sulkujen sisll olevan 0.25:den 0.5:deksi
// Tornin (yhden kerroksen) korkeus on tile_y*korkeus

/*  Seuraavat muutama kohtaa ovat tt muotoa

    Tm on hieman huonosti toteutettu koska elementin lopullinen korkeus mritetn tss. Sitten kun samaa elementti halutaan kytt useampaan kertaan,
    tuleekin korkeus mritt kahdessa paikassa (toinen tss, toinen heti niden elementinkokoamislauseiden jlkeen).

  #local hole_center = <u,v>;                       // Seinn tulevan reijn keskikohta
  #local hole_radius = r;                           // Seinn tulevat reijn sde (suunnilleen)
  
  #local i = 0;                                     // Laskuri, latoo tiili pllekkisiin kerroksiin
  #local torni = union {
    #while (i < tile_y)                             // Kuten tuli sanottua
      #local j = 0;      
      #local temp = 0.5*pituus*mod(i,2);            // Pient optimointia, limitt pllekkiset tiilet niin etteivt ne ole suoraan toistensa pll.
      #local temp2 = (i+2*tile_y)*korkeus;          // Samoin, mritt elementin korkeuden. Tst aiheutuu se korkeuden mrittelyn hassu piirre (tile_y:n vakiokerroin).
      #while (j < tile_x)
        #if (abs(hole_center.x - i) + abs(hole_center.y - j) > hole_radius )      // Laskee onko piirrettv tiili riittvn kaukana reijn keskikohdasta
        object { tiili translate <pituus*j+temp,temp2,0> }#end                    // jotta se voitaisiin piirt.
        #local j  = j + 1;
      #end
      #local i  = i + 1;
    #end
  }
  
  #local torni_n = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }  // Sijoitetaan elementti omaan muuttujaansa, numerointi ei noudatan
                                                                                                     // kovinkaan kummallista logiikkaa.
*/

#local i = 0;                
#local torni = union {
  #while (i < tile_y)
    #local j = 0;              
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = i*korkeus;
    #while (j < tile_x)
      object { tiili translate <pituus*j+temp,temp2,0> }
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#local torni_1 = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

#local hole_center = <4,7>;
#local hole_radius = 5;

#local i = 0;                
#local torni = union {
  #while (i < tile_y)
    #local j = 0;              
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = (i+tile_y)*korkeus;
    #while (j < tile_x)
      #if (abs(hole_center.x - i) + abs(hole_center.y - j - 1) > hole_radius )
      object { tiili translate <pituus*j+temp,temp2,0> }#end
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#local torni_2 = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

#local hole_center = <4,1>;
#local hole_radius = 4;

#local i = 0;                
#local torni = union {
  #while (i < tile_y)
    #local j = 0;              
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = (i+tile_y)*korkeus;
    #while (j < tile_x)
      #if (abs(hole_center.x - i) + abs(hole_center.y - j) > hole_radius )
      object { tiili translate <pituus*j+temp,temp2,0> }#end
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#local torni_3 = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

#local hole_center = <5,6>;
#local hole_radius = 6;

#local i = 0;                
#local torni = union {
  #while (i < tile_y)
    #local j = 0;              
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = (i+2*tile_y)*korkeus;
    #while (j < tile_x)
      #if (abs(hole_center.x - i) + abs(hole_center.y - j) > hole_radius )
      object { tiili translate <pituus*j+temp,temp2,0> }#end
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#local torni_4 = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

#local hole_center = <4,2>;
#local hole_radius = 6;

#local i = 0;
#local torni = union {
  #while (i < tile_y)
    #local j = 0;
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = (i+2*tile_y)*korkeus;
    #while (j < tile_x)
      #if (abs(hole_center.x - i) + abs(hole_center.y - j) > hole_radius )
      object { tiili translate <pituus*j+temp,temp2,0> }#end
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#local torni_5 = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

#local hole_center = <3,0>;
#local hole_radius = 1;

#local i = 0;                
#local torni = union {
  #while (i < tile_y)
    #local j = 0;              
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = (i+2*tile_y)*korkeus;
    #while (j < tile_x)
      #if (abs(hole_center.x - i) + abs(hole_center.y - j) > hole_radius )
      object { tiili translate <pituus*j+temp,temp2,0> }#end
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#local torni_6 = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

#local hole_center = <1,5>;
#local hole_radius = 5;

#local i = 0;                
#local torni = union {
  #while (i < tile_y)
    #local j = 0;              
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = (i+3*tile_y)*korkeus;
    #while (j < tile_x)
      #if (abs(hole_center.x - i) + abs(hole_center.y - j) > hole_radius )
      object { tiili translate <pituus*j+temp,temp2,0> }#end
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#local torni_7 = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

#local hole_center = <0,2>;
#local hole_radius = 5;

#local i = 0;                
#local torni = union {
  #while (i < tile_y)
    #local j = 0;              
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = (i+3*tile_y)*korkeus;
    #while (j < tile_x)
      #if (abs(hole_center.x - i) + abs(hole_center.y - j) > hole_radius )
      object { tiili translate <pituus*j+temp,temp2,0> }#end
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#local torni_8 = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

// Tornin ylosa
#local i = 0;                
#local torni = union {
  #while (i < 3)
    #local j = 0;              
    #local temp = 0.5*pituus*mod(i,2);
    #local temp2 = i*korkeus;
    #while (j < tile_x)
      #if (mod(j,2) = 0 | i !=2 ) object { tiili translate <pituus*j+temp,temp2,0> } #end
      #local j  = j + 1;
    #end
    #local i  = i + 1;
  #end
}

#declare torni = object { torni translate <-pituus*(tile_x*.5+0.25),0,-pituus*(tile_x*.5+0.25)> }

// Kootaan elementit yhteen. Valintalauseen sisll on kaksi vaihtoehtoa: ensimminen jos tornin halutaan
// olevan ehj ja toinen jossa torni on hieman huonommassa kunnossa.

// Tss mys mritelln uudelleen niiden elementtien korkeus, joita kytetn useammassa kerroksessa.

#local torni = union {

  #if (kunto)
  
    // Ensimminen kerros
    difference {
      object { torni_1 }
      object { ovi_bound }
      object { ikkuna_bound }
      texture { wall_colour }
    }
    difference {
      object { torni_1}
      object { ikkuna_bound }
      rotate 90*y 
      texture { wall_colour }
    }
    difference {
      object { torni_1}
      object { ikkuna_bound }
      rotate 180*y 
      texture { wall_colour }
    }
    difference {
      object { torni_1}
      object { ikkuna_bound }
      rotate -90*y 
      texture { wall_colour }
    }
  

    // Toinen kerros
    difference {
      object { torni_1 translate y*tile_y*korkeus }
      object { ikkuna_bound translate y*tile_y*korkeus }
      texture { wall_colour }
    }

    difference {
      object { torni_1 translate y*tile_y*korkeus }
      object { ikkuna_bound translate y*tile_y*korkeus }
      rotate 90*y
      texture { wall_colour }
    }
    difference {
      object { torni_1 translate y*tile_y*korkeus }
      object { ikkuna_bound translate y*tile_y*korkeus }
      rotate 180*y
      texture { wall_colour }
    }
    difference {
      object { torni_1 translate y*tile_y*korkeus }
      object { ikkuna_bound translate y*tile_y*korkeus }
      rotate -90*y
      texture { wall_colour }
    }

    // Kolmas kerros
    difference {
      object { torni_1 translate y*2*tile_y*korkeus }
      object { ikkuna_bound translate y*2*tile_y*korkeus }
      texture { wall_colour }
    }
    difference {
      object { torni_1 translate y*2*tile_y*korkeus }
      object { ikkuna_bound translate y*2*tile_y*korkeus }
      rotate 90*y
      texture { wall_colour }
    }
    difference {
      object { torni_1 translate y*2*tile_y*korkeus }
      object { ikkuna_bound translate y*2*tile_y*korkeus }
      rotate 180*y
      texture { wall_colour }
    }
    difference {
      object { torni_1 translate y*2*tile_y*korkeus }
      object { ikkuna_bound translate y*2*tile_y*korkeus }
      rotate -90*y
      texture { wall_colour }
    }
    

    // Neljs kerros
    difference {
      object { torni_1 translate y*3*tile_y*korkeus }
      object { ikkuna_bound translate y*3*tile_y*korkeus }
      texture { wall_colour }
    }
    difference {
      object { torni_1 translate y*3*tile_y*korkeus }
      object { ikkuna_bound translate y*3*tile_y*korkeus }
      rotate 90*y
      texture { wall_colour }
    }
    difference {
      object { torni_1 translate y*3*tile_y*korkeus }
      object { ikkuna_bound translate y*3*tile_y*korkeus }
      rotate 180*y
      texture { wall_colour }
    }
    difference {
      object { torni_1 translate y*3*tile_y*korkeus }
      object { ikkuna_bound translate y*3*tile_y*korkeus }
      rotate -90*y
      texture { wall_colour }
    }

    // Ylmuuri
      object { torni translate y*4*tile_y*korkeus rotate y*0 }
      object { torni translate y*4*tile_y*korkeus rotate y*90 }
      object { torni translate y*4*tile_y*korkeus rotate y*180 }
      object { torni translate y*4*tile_y*korkeus rotate y*270 }
  

  #else
  
    union {
    // Ensimminen kerros
    difference {
      object { torni_1 }
      object { ovi_bound }
      object { ikkuna_bound }
    }
    difference {  // Vasen sein
      object { torni_1 }
      object { ikkuna_bound }
      rotate 90*y 
    }
    difference {  // Takasein
      object { torni_1 }
      object { ikkuna_bound }
      rotate 180*y 
    }
    difference {  // Oikea sein
      object { torni_1 }
      object { ikkuna_bound }
      rotate -90*y 
    }
  
    // Toinen kerros
    difference {  // Etusein
      object { torni_2 }
      object { ikkuna_bound translate y*tile_y*korkeus }
    }
    difference {  // Vasen sein
      object { torni_1 translate y*tile_y*korkeus }
      object { ikkuna_bound translate y*tile_y*korkeus }
      rotate 90*y 
    }
    difference {  // Takasein
      object { torni_1 translate y*tile_y*korkeus }
      object { ikkuna_bound translate y*tile_y*korkeus }
      rotate 180*y
    }
    difference {  // Oikea sein
      object { torni_3 }
      object { ikkuna_bound translate y*tile_y*korkeus }
      rotate -90*y 
    }    

    // Kolmas kerros
    difference {  // Kolmannen kerroksen etusein
      object { torni_4 }
      object { ikkuna_bound translate y*2*tile_y*korkeus }
    }
    difference {  // Kolmannen kerroksen vasen sein
      object { torni_1 translate 2*y*tile_y*korkeus }
      object { ikkuna_bound translate y*2*tile_y*korkeus }
      rotate 90*y  
    }
    difference {  // Kolmannen kerroksen takasein
      object { torni_1 translate 2*y*tile_y*korkeus }
      object { ikkuna_bound translate y*2*tile_y*korkeus }
      rotate 180*y 
    }
    difference {  // Kolmannen kerroksen oikea sein
      object { torni_5 }
      object { ikkuna_bound translate y*2*tile_y*korkeus }
      rotate -90*y 
    }    

    // Neljs kerros
    difference {  // Neloskerroksen etusein
      object { torni_7 }
      object { ikkuna_bound translate y*3*tile_y*korkeus }
    }
    difference {  // Neloskerroksen vasen sein 
      object { torni_1 translate 3*y*tile_y*korkeus }
      object { ikkuna_bound translate y*3*tile_y*korkeus }
      rotate 90*y  
    }
    difference {  // Neloskerroksen takasein
      object { torni_1 translate 3*y*tile_y*korkeus }
      object { ikkuna_bound translate y*3*tile_y*korkeus }
      rotate 180*y 
    }
    difference {  // Neloskerroksen oikea sein
      object { torni_8 }
      object { ikkuna_bound translate y*3*tile_y*korkeus }
      rotate -90*y 
    }

    union { // Kattoa reunustavat hammaskivet
      object { torni translate y*4*tile_y*korkeus rotate y*0 }
      object { torni translate y*4*tile_y*korkeus rotate y*90 }
      object { torni translate y*4*tile_y*korkeus rotate y*180 }
      object { torni translate y*4*tile_y*korkeus rotate y*270 }
    }

      texture { wall_colour }

      texture {   // Toisen kerroksen oikean seinn tummentuma
        pigment {
          spherical
          color_map {
              [0 color  rgbt 1]
              [.5 color rgbt 0]
              [1 color  rgbt 0]
          }
          scale <3.5,2.5,3.5>
          translate <sisa,1.5*kerros,-sisa+.4>
        }
      }
      texture {   // Toisen kerroksen etuseinn tummentuma
        pigment {
          spherical
          color_map {
              [0 color  rgbt 1]
              [.5 color rgbt .2]
              [1 color  rgbt 0]
          }
          scale <3.5,2.5,3.5>
          translate <0.4,1.5*kerros,-sisa>
        }
      }
      texture {   // Kolmoskerroksen oikean seinn tummentuma
        pigment {
          spherical
          color_map {
              [0 color  rgbt 1]
              [.5 color rgbt 0]
              [1 color  rgbt 0]
          }
          scale <3,2.5,3>
          translate <sisa,2.5*kerros,-0.4>
        }
      }
      texture {   // Neloskerroksen etuseinn tummentuma 
        pigment {
          spherical
          color_map {
              [0 color  rgbt 1]
              [.5 color rgbt 0]
              [1 color  rgbt 0]
          }
          scale <3.75,3,3.75>
          translate <0.4,3*kerros,-sisa>
        }
      }
      texture { // Neloskerroksen oikean seinn tummentuma
        pigment {
          spherical
          color_map {
              [0 color  rgbt .9]
              [.5 color rgbt 0]
              [1 color  rgbt 0]
          }
          scale <3,2.5,3>
          translate <sisa,3*kerros,-0.4>
        }
      }


  } // End of union

  #end

}



#ifndef (no_tower)

  object { torni }

#end